
package w83a.xml;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.XMLReader;

import w83a.w83aUtilidadesComunes.W83AErrorCodes;
import w83a.w83aUtilidadesComunes.W83aException;
import w83a.xml.exception.W83AXmlException;



/**
 * Validacin de una fuente xml contra un esquema xsd
 */
public class W83AXmlSchemaValidation implements java.io.Serializable{//NOPMD

	private static final long serialVersionUID = 1L;
	/**
     * Permite validar una fuente xml contra un esquema.
     * 
     * @param xsdPathname
     *            Ruta de acceso y nombre del fichero con el esquema
     * @param xmlDocument
     *            Ruta de acceso y nombre del fichero con la fuente xml
     * @throws W83AException
     *             Si el chequeo no es satisfactorio.
     */
	public static void validationXMLSchema(String xsdPathname, String xmlDocument)
			throws W83aException, W83AXmlException {
    	
        if (log.isLoggable(Level.INFO))
        {
        	log.info("validationXMLSchema(...)");
        }
        
        W83AXmlValidator validator = new W83AXmlValidator ();
        validator.create(false);
        
        validator.setSchemaURL(xsdPathname);
        boolean isValid = validator.checkXmlStringText(xmlDocument);
        if (!isValid) {
        	
            if (log.isLoggable(Level.INFO)) {
            	log.info("isValid?:: " + isValid);
            	log.info(validator.getCheckInfo());
            }
        	throw new W83aException("w83a", W83AErrorCodes.EC_EVALUATION_XML_ERROR);
        }
    }
	
	final public static XMLReader makeXMLReader() { 
	    try {
            final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(false);
            final SAXParser saxParser = saxParserFactory.newSAXParser();
            final XMLReader parser = saxParser.getXMLReader();
            
            return parser;
        } catch (Exception e) {
        }
        
        return null;
	}	
    
	private static Logger log =Logger.getLogger(W83AXmlSchemaValidation.class.getName());//NOPMD

}
